{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:37:39 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MMSystem, MMObj, MMWavIn,
  MMACMDlg, MMCstDlg, MMPCMSup, MMWaveIO, MMUtils, MMDIBCv, MMMeter,
  MMPanel, MMWave, MMConect, MMDesign, MMDSPObj, MMLevel, MMRingBf,
  MMGauge, MMHook, MMAudio;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    lblBytes: TLabel;
    lblTime: TLabel;
    ReadyBtn: TButton;
    RecordBtn: TButton;
    WaveIn1: TMMWaveIn;
    Gauge1: TMMGauge;
    NewBtn: TButton;
    MMWaveSaveDialog1: TMMWaveSaveDialog;
    MMACM1: TMMACM;
    lblFormat: TLabel;
    MMPanel2: TMMPanel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    StopBtn: TButton;
    MMPanel1: TMMPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel5: TBevel;
    Meter1: TMMMeter;
    Meter2: TMMMeter;
    Bevel7: TBevel;
    Bevel8: TBevel;
    Bevel6: TBevel;
    ckBVoiceActivated: TCheckBox;
    WaveFile1: TMMWaveFile;
    MMConnector1: TMMConnector;
    MMDesigner1: TMMDesigner;
    procedure ReadyBtnClick(Sender: TObject);
    procedure RecordBtnClick(Sender: TObject);
    procedure WaveIn1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure WaveIn1Start(Sender: TObject);
    procedure WaveIn1Stop(Sender: TObject);
    procedure NewBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure WaveFile1Close(Sender: TObject);

  public
    FreeSpace: int64;
    Threshold: Smallint;

    procedure DrawFormat;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses unit2;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.ReadyBtnClick(Sender: TObject);
begin
   if (WaveFile1.Wave.FileName <> '') then
   begin
      { first open the device }
      WaveIn1.Open;
      { here you can modify the wave file Info-Chunk-List (option) }
      WaveFile1.Wave.SetInfoChunk('ISFT','Multimedia Tools for Delphi');
      { set the IO cache size (option) }
      WaveFile1.Wave.IOBufferSize := 100000;
      { now start the sampling }
      WaveIn1.Start;

      { here we set the value to activate the recorder }
      if WaveFile1.Wave.PWaveFormat^.wBitsPerSample = 8 then
         Threshold := 160
      else
         Threshold := 1000;
   end;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.RecordBtnClick(Sender: TObject);
begin
   WaveFile1.Enabled := not WaveFile1.Enabled;
   if WaveFile1.Enabled then RecordBtn.Caption := '&Save: On'
   else RecordBtn.Caption := '&Save: Off';
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.StopBtnClick(Sender: TObject);
begin
   WaveIn1.Stop;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.WaveIn1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   PeakL,PeakR: SmallInt;

begin
   if ckBVoiceActivated.Checked then
   begin
      MMConnector1.GetPeak(PeakL,PeakR);
      if (abs(PeakL) > Threshold) or (abs(PeakR) > Threshold) then
         WaveFile1.Enabled := True
      else
         WaveFile1.Enabled := False
   end;

   if WaveFile1.Enabled then
   begin
      lblBytes.Caption := IntToStr(WaveFile1.Wave.DataSize) + ' Bytes';
      Gauge1.Progress := Round((WaveFile1.Wave.DataSize * 100.0) / FreeSpace+0.51);
      RecordBtn.Caption := '&Save: On';
   end
   else RecordBtn.Caption := '&Save: Off';

   lblTime.Caption := IntToStr(WaveIn1.Position div 1000) +  ' second';
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.WaveIn1Start(Sender: TObject);
var
   Dummy: int64;
begin
   Gauge1.Progress := 0;
   if (WaveFile1.Wave.FileName <> '') then
       GetDiskStats(WaveFile1.Wave.FileName,FreeSpace,Dummy);
   NewBtn.Enabled := False;
   ReadyBtn.Enabled := False;
   StopBtn.Enabled := True;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.WaveIn1Stop(Sender: TObject);
begin
   Gauge1.Progress := 0;
   NewBtn.Enabled := True;
   ReadyBtn.Enabled := True;
   StopBtn.Enabled := False;
   WaveIn1.Close;   { finally close the device and the file }
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.WaveFile1Close(Sender: TObject);
begin
   { file has closed, disk full ? However, stop it }
   StopBtnClick(nil);
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   WaveIn1.DeviceID := WAVE_MAPPER;

   DrawFormat;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   WaveIn1.Close;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.NewBtnClick(Sender: TObject);
var
   FormatOK: Boolean;
begin
   if MMWaveSaveDialog1.Execute then
   begin
      FormatOK := False;
      WaveFile1.Wave.FileName := MMWaveSaveDialog1.FileName;
      if MMACM1.ACMPresent then
      begin
         if MMACM1.ChooseFormat(WaveIn1.PWaveFormat,'Select Format') then
         begin
            WaveIn1.PWaveFormat := MMACM1.PWaveFormat;
            DrawFormat;
            FormatOK := True;
         end;
      end
      else
      begin
         { if the ACM is not present, insert your own Choose dialog ! }
         FmtDialog.Wave := WaveFile1.Wave;
         if FmtDialog.ShowModal = mrOK then
         begin
            WaveIn1.PWaveFormat := FmtDialog.PWaveFormat;
            DrawFormat;
            FormatOK := True;
         end;
      end;

      if FormatOK then
      begin
         ReadyBtn.Enabled := WaveFile1.Wave.FileName <> '';
         RecordBtn.Enabled := ReadyBtn.Enabled;
      end;
   end;
end;

{-- TForm1 -------------------------------------------------------------}
procedure TForm1.DrawFormat;
var
   sFormat,sFormatTag: String;

begin
   if MMACM1.ACMPresent then
   begin
      MMACM1.GetFormatDescription(WaveIn1.PWaveFormat,sFormatTag,sFormat);
   end
   else
   begin
      { if the ACM is not present, get the format in another way ! }
      wioGetFormatName(WaveIn1.PWaveFormat,sFormatTag);
      wioGetFormat(WaveIn1.PWaveFormat,sFormat);
   end;
   lblFormat.Caption := 'Format:  '+sFormatTag+' '+sFormat;
end;

end.


